<?php
require 'conexion.php'; // Incluye el archivo de conexión

// Variables para almacenar los datos del pedido
$Pcantidad = $Prowid = $Corigen = '';
$vendedorNombre = 'Nombre del Vendedor'; // Este valor debería venir de otro formulario o sesión
$vendedorId = 1; // Este valor debería venir de otro formulario o sesión

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['codigo_pedido'])) {
    $codigoPedido = $_POST['codigo_pedido'];

    // Consulta SQL para obtener los detalles del pedido
    $sql = "SELECT DISTINCT s.nom as Cliente, c.rowid as id_pedido, c.ref as Ref_Pedido, c.date_creation as Fecha_Creacion, 
            p.rowid as id_producto, p.label as Producto, cd.description as descripcion, cd.qty as Cantidad, 
            u.nom_unidad as Tipo_despacho, extra2.cantidad_despacho as Cantidad_Despacho
            FROM llx_societe as s 
            LEFT JOIN llx_c_departements as d ON s.fk_departement = d.rowid 
            LEFT JOIN llx_c_country as co ON s.fk_pays = co.rowid, 
            llx_commande as c 
            LEFT JOIN llx_projet as pj ON c.fk_projet = pj.rowid 
            LEFT JOIN llx_user as uc ON c.fk_user_author = uc.rowid 
            LEFT JOIN llx_user as uv ON c.fk_user_valid = uv.rowid 
            LEFT JOIN llx_commande_extrafields as extra ON c.rowid = extra.fk_object , 
            llx_commandedet as cd 
            LEFT JOIN llx_commandedet_extrafields as extra2 on cd.rowid = extra2.fk_object 
            LEFT JOIN llx_udd as u on  extra2.cestas = u.cod_unidad
            LEFT JOIN llx_product as p on cd.fk_product = p.rowid 
            LEFT JOIN llx_product_extrafields as extra3 on p.rowid = extra3.fk_object 
            WHERE c.fk_soc = s.rowid 
            AND c.rowid = cd.fk_commande
            AND c.entity IN (1) 
            AND c.fk_statut = 1 			
            AND c.ref = '$codigoPedido'";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Asignar valores a las variables (solo para la primera fila)
        $row = $result->fetch_assoc();
        $Pcantidad = $row['Cantidad'];
        $Prowid = $row['id_producto'];
        $Corigen = $row['id_pedido'];

        // Reiniciar el puntero del resultado para iterar desde el principio
        $result->data_seek(0);
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Despacho de Productos</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .logo { width: 100px; }
        .title { font-family: 'Arial', sans-serif; font-size: 24px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <img src="logo.png" alt="Logo" class="logo">
                <h1 class="title">Despacho de Productos</h1>
            </div>
        </div>
        <form method="post">
            <div class="form-group">
                <label for="codigo_pedido">Código del Pedido:</label>
                <input type="text" class="form-control" id="codigo_pedido" name="codigo_pedido" required>
            </div>
            <button type="submit" class="btn btn-primary">Buscar Pedido</button>
        </form>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['codigo_pedido']) && $result->num_rows > 0): ?>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Cliente</th>
                            <th>Referencia Pedido</th>
                            <th>Fecha Creación</th>
                            <th>Producto</th>
                            <th>Descripción</th>
                            <th>Cantidad</th>
                            <th>Tipo Despacho</th>
                            <th>Cantidad Despacho</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['Cliente']; ?></td>
                                <td><?php echo $row['Ref_Pedido']; ?></td>
                                <td><?php echo $row['Fecha_Creacion']; ?></td>
                                <td><?php echo $row['Producto']; ?></td>
                                <td><?php echo $row['descripcion']; ?></td>
                                <td><?php echo $row['Cantidad']; ?></td>
                                <td><?php echo $row['Tipo_despacho']; ?></td>
                                <td><?php echo $row['Cantidad_Despacho']; ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            <form method="post" action="despachar.php">
                <input type="hidden" name="Pcantidad" value="<?php echo $Pcantidad; ?>">
                <input type="hidden" name="Prowid" value="<?php echo $Prowid; ?>">
                <input type="hidden" name="Corigen" value="<?php echo $Corigen; ?>">
                <button type="submit" class="btn btn-success">Despachar</button>
            </form>
        <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['codigo_pedido']) && $result->num_rows == 0): ?>
            <div class="alert alert-warning mt-3" role="alert">
                No se encontraron resultados para el código de pedido: <?php echo htmlspecialchars($_POST['codigo_pedido']); ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>